<?php
/**
 * The main template file for display gallery page.
 *
 * @package WordPress
*/

/**
*	Get Current page object
**/
$page = get_page($post->ID);
$current_page_id = '';

if(isset($page->ID))
{
    $current_page_id = $page->ID;
}

//Check if gallery template
$grandwedding_page_gallery_id = grandwedding_get_page_gallery_id();
if(!empty($grandwedding_page_gallery_id))
{
	$current_page_id = $grandwedding_page_gallery_id;
}

//important to apply dynamic header & footer style
$grandwedding_homepage_style = grandwedding_get_homepage_style();

$tg_full_menu_transparent = kirki_get_option('tg_full_menu_transparent');
if(empty($tg_full_menu_transparent))
{
	$grandwedding_homepage_style = 'fullscreen_white';
}
else
{
	$grandwedding_homepage_style = 'fullscreen';
}
grandwedding_set_homepage_style($grandwedding_homepage_style);

get_header();

//Run gallery script data
wp_enqueue_style("supersized", get_template_directory_uri()."/css/supersized.css", false, GRANDWEDDING_THEMEVERSION, "all");

wp_enqueue_script("supersized", get_template_directory_uri()."/js/supersized.3.2.7.min.js", false, GRANDWEDDING_THEMEVERSION, true);
wp_enqueue_script("supersized-shutter", get_template_directory_uri()."/js/supersized.shutter.min.js", false, GRANDWEDDING_THEMEVERSION, true);
wp_enqueue_script("touchwipe", get_template_directory_uri()."/js/jquery.touchwipe.1.1.1.js", false, GRANDWEDDING_THEMEVERSION, true);
wp_enqueue_script("grandwedding-supersized-gallery", admin_url('admin-ajax.php')."?action=grandwedding_script_supersized_gallery&gallery_id=".$current_page_id, false, GRANDWEDDING_THEMEVERSION, true);
?>
<?php
	$tg_full_arrow = kirki_get_option('tg_full_arrow');
	
	if(!empty($tg_full_arrow))
	{
?>
<div id="thumb-tray" class="load-item">
    <a id="prevslide" class="load-item"></a>
    <a id="nextslide" class="load-item"></a>
</div>
<?php
	}
	else
	{
?>
<a id="nextslide" class="load-item"></a>
<?php
	}
?>

<div id="controls-wrapper" class="load-item">
	<div id="controls">
	    <?php
	        $tg_full_image_caption = kirki_get_option('tg_full_image_caption');
	        if(!empty($tg_full_image_caption))
	        {
	    ?>
	        <!--Slide captions displayed here--> 
	        <div id="slidecaption"></div>
	    <?php
	        }
	    ?>
	</div>
</div>

<?php get_footer(); ?>