<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class PagesPricing extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'pages-pricing';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Pages Pricing', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'pages' ];
	}

	public function get_keywords() {
		return [ 'Pages Pricing', 'carousel' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
		$position_options = [
			''              => esc_html__('Default', 'bdevs-elementor'),
			'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
			'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
			'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
			'center'        => esc_html__('Center', 'bdevs-elementor') ,
			'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
			'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
			'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
			'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
			'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
		];

		return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_pricing',
			[
				'label' => esc_html__( 'Pricing Widget', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'pricing_bg',
			[
				'label'       => __( 'Pricing Background', 'bdevs-elementor' ),
				'type'        => Controls_Manager::SELECT,
				'dynamic' => [ 'active' => true ],
		        'options'   => [
		        '1'  => esc_html__( 'White Bg', 'bdevs-elementor' ),
		        '2'  => esc_html__( 'Pink Bg', 'bdevs-elementor' ),
		        ],
		        'default'   => '1',
			]
		);

		$this->add_control(
			'heading_meta',
			[
				'label'       => __( 'Heading Meta', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Heading Meta', 'bdevs-elementor' ),
				'default'     => __( 'It is Heading Meta', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
				'default'     => __( 'It is Heading', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'Pricing Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => [				
					[
						'name'        => 'tab_title',
						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Tab Title' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'tab_price',
						'label'       => esc_html__( 'Price', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Tab Price' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'tab_subtitle',
						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Tab Subtitle' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'tab_option',
						'label'       => esc_html__( 'Option', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Tab Option' , 'bdevs-elementor' ),
					],
					[
						'name'        => 'tab_link',
						'label'       => esc_html__( 'Link', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Tab Link' , 'bdevs-elementor' ),
					],
					[
						'name'        => 'tab_button',
						'label'       => esc_html__( 'Button', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Tab Button' , 'bdevs-elementor' ),
					],
				],
			]
		);


		$this->end_controls_section();



		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		); 

		$this->add_control(
			'show_heading_meta',
			[
				'label'   => esc_html__( 'Show Heading Meta', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

	}

	public function render() {

		$settings  = $this->get_settings_for_display();
		?>

		<?php if( wp_kses_post($settings['pricing_bg']) == '1'): ?>
		<div class="price-section pt-60 pb-60 price">
		<?php elseif( wp_kses_post($settings['pricing_bg']) == '2'): ?>
		<div class="price-section pt-60 pb-60 price bg-pink">
		<?php endif; ?> 
			<div class="container-fluid">
				<div class="row">
					<div class="col-md-12"> 
						<?php if (( '' !== $settings['heading_meta'] ) && ( $settings['show_heading_meta'] )): ?>
						<span class="heading-meta"><?php echo wp_kses_post($settings['heading_meta']); ?></span>
						<?php endif; ?>
						<?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )): ?>
						<h2 class="pwe-heading animate-box" data-animate-effect="fadeInLeft"><?php echo wp_kses_post($settings['heading']); ?></h2>
						<?php endif; ?>
					</div>
				</div>
				<div class="row">
					<div class="col-md-12 owl-carousel owl-theme">
						<?php foreach ( $settings['tabs'] as $item ) : ?>
							<div class="item">
								<div class="cont">
									<div class="type">
										<?php if ( '' !== $item['tab_title'] ) : ?>
										<h6><?php echo wp_kses_post($item['tab_title']); ?></h6>
										<?php endif; ?>
									</div>
									<div class="value">
										<?php if ( '' !== $item['tab_price'] ) : ?>
										<h4><?php echo wp_kses_post($item['tab_price']); ?></h4>
										<?php endif; ?>
										<?php if ( '' !== $item['tab_subtitle'] ) : ?>
										<p><?php echo wp_kses_post($item['tab_subtitle']); ?></p>
										<?php endif; ?>
									</div>
									<div class="feat">
										<ul>
											<?php if ( '' !== $item['tab_option'] ) : ?>
											<?php echo wp_kses_post($item['tab_option']); ?>
											<?php endif; ?>
										</ul>
									</div>
								</div>
								<?php if ( '' !== $item['tab_button'] ) : ?>
								<div class="btn-contact"> <a href="<?php echo wp_kses_post($item['tab_link']); ?>"><span><?php echo wp_kses_post($item['tab_button']); ?></span></a> </div>
								<?php endif; ?>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
			</div>
		</div>

		<?php
	}

}
